/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.inventory;

import io.github.noeppi_noeppi.libx.inventory.VanillaWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class BaseItemStackHandler
extends ItemStackHandler {
    private final IItemHandlerModifiable unrestricted = new Unrestricted();
    private final Consumer<Integer> onContentsChanged;
    private final Map<Integer, Integer> slotSizeMap;
    private BiFunction<Integer, ItemStack, Boolean> slotValidator;
    private int maxStackSize = 64;
    private int[] outputSlots = null;
    private int[] inputSlots = null;

    public BaseItemStackHandler(int size) {
        this(size, null);
    }

    public BaseItemStackHandler(int size, Consumer<Integer> onContentsChanged) {
        super(size);
        this.onContentsChanged = onContentsChanged;
        this.slotSizeMap = new HashMap<Integer, Integer>();
        this.slotValidator = null;
    }

    public BaseItemStackHandler(int size, Consumer<Integer> onContentsChanged, BiFunction<Integer, ItemStack, Boolean> slotValidator) {
        super(size);
        this.onContentsChanged = onContentsChanged;
        this.slotSizeMap = new HashMap<Integer, Integer>();
        this.slotValidator = slotValidator;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.outputSlots != null && ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputSlots != null && !ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.slotSizeMap.containsKey(slot) ? this.slotSizeMap.get(slot) : this.maxStackSize;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.slotValidator == null || this.slotValidator.apply(slot, stack) != false;
    }

    public void onContentsChanged(int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.accept(slot);
        }
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public void setDefaultSlotLimit(int size) {
        this.maxStackSize = size;
    }

    public void addSlotLimit(int slot, int size) {
        this.slotSizeMap.put(slot, size);
    }

    public void setSlotValidator(BiFunction<Integer, ItemStack, Boolean> validator) {
        this.slotValidator = validator;
    }

    public void setInputSlots(int ... slots) {
        Arrays.sort(slots);
        this.inputSlots = slots;
    }

    public void setOutputSlots(int ... slots) {
        this.outputSlots = slots;
    }

    public boolean isInputEmpty() {
        if (this.inputSlots != null) {
            for (int i : this.inputSlots) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOutputEmpty() {
        if (this.outputSlots != null) {
            for (int i : this.outputSlots) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public VanillaWrapper toIInventory() {
        return new VanillaWrapper((IItemHandlerModifiable)this, null);
    }

    public VanillaWrapper toIInventory(@Nullable Runnable dirty) {
        return new VanillaWrapper((IItemHandlerModifiable)this, null);
    }

    public IItemHandlerModifiable getUnrestricted() {
        return this.unrestricted;
    }

    private class Unrestricted
    implements IItemHandlerModifiable {
        private Unrestricted() {
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            BaseItemStackHandler.this.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return BaseItemStackHandler.this.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return BaseItemStackHandler.this.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            BaseItemStackHandler.this.validateSlotIndex(slot);
            ItemStack existing = this.getStackInSlot(slot);
            int limit = BaseItemStackHandler.this.getStackLimit(slot, stack);
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (!simulate) {
                if (existing.func_190926_b()) {
                    this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
                BaseItemStackHandler.this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            BaseItemStackHandler.this.validateSlotIndex(slot);
            ItemStack existing = this.getStackInSlot(slot);
            if (existing.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int toExtract = Math.min(amount, existing.func_77976_d());
            if (existing.func_190916_E() <= toExtract) {
                if (!simulate) {
                    this.setStackInSlot(slot, ItemStack.field_190927_a);
                    BaseItemStackHandler.this.onContentsChanged(slot);
                    return existing;
                }
                return existing.func_77946_l();
            }
            if (!simulate) {
                this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
                BaseItemStackHandler.this.onContentsChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        public int getSlotLimit(int slot) {
            return BaseItemStackHandler.this.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return BaseItemStackHandler.this.isItemValid(slot, stack);
        }
    }
}

